/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;

public class ResourceColorManager
implements ISafeManagerReloadListener,
IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ResourceColorManager.class);
    private static final String COLORS_PATH = "mantle/colors.json";
    private static final String FALLBACK_PATH = "tinkering/colors.json";
    public static final class_5251 WHITE = class_5251.method_27717((int)-1);
    public static final ResourceColorManager INSTANCE = new ResourceColorManager();
    private static Map<String, class_5251> COLORS = Collections.emptyMap();

    public static void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    private static void parseRecursive(String prefix, JsonObject json, Map<String, class_5251> colors) {
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonObject()) {
                ResourceColorManager.parseRecursive(prefix + key + ".", element.getAsJsonObject(), colors);
                continue;
            }
            if (element.isJsonPrimitive()) {
                String fullPath = prefix + key;
                if (colors.containsKey(fullPath)) continue;
                String text = element.getAsString();
                class_5251 color = class_5251.method_27719((String)text);
                if (color == null) {
                    log.error("Color at key '{}' could not be parsed, got '{}'", (Object)fullPath, (Object)text);
                    continue;
                }
                colors.put(fullPath, color);
                continue;
            }
            if (element.isJsonNull()) continue;
            log.error("Skipping color key '{}' as the value is not a string", (Object)key);
        }
    }

    @Override
    public void onReloadSafe(class_3300 manager) {
        int i;
        HashMap<String, class_5251> colors = new HashMap<String, class_5251>();
        List<JsonObject> jsonFiles = JsonHelper.getFileInAllDomainsAndPacks(manager, COLORS_PATH, null);
        for (i = jsonFiles.size() - 1; i >= 0; --i) {
            ResourceColorManager.parseRecursive("", jsonFiles.get(i), colors);
        }
        jsonFiles = JsonHelper.getFileInAllDomainsAndPacks(manager, FALLBACK_PATH, COLORS_PATH);
        for (i = jsonFiles.size() - 1; i >= 0; --i) {
            ResourceColorManager.parseRecursive("", jsonFiles.get(i), colors);
        }
        COLORS = colors;
    }

    @Nullable
    public static class_5251 getOrNull(String path) {
        return COLORS.get(path);
    }

    public static class_5251 getTextColor(String path) {
        return COLORS.getOrDefault(path, WHITE);
    }

    public static int getColor(String path) {
        return ResourceColorManager.getTextColor(path).method_27716();
    }

    public class_2960 getFabricId() {
        return Mantle.getResource("resource_color_manager");
    }

    private ResourceColorManager() {
    }
}

